/******************************************************************************/
/*                                                                            */
/*      ctk_file_desc.hh                                                      */
/*                                                                            */
/*      Author: Jon Barker, Sheffield University                              */
/*                                                                            */
/*      CTK VERSION 1.3.5  Apr 22, 2007                                   */
/*                                                                            */
/******************************************************************************/

#ifndef CTK_FILE_DESC_HH
#define CTK_FILE_DESC_HH

#include <sys/stat.h>
#include <string>

#include "ctk_local.hh"

/******************************************************************************/
/*									      */
/*	CLASS NAME: FileDescriptor	                 	       	      */
/*									      */
/******************************************************************************/

class FileDescriptor {

private:

  string filename_;
  time_t mod_time_;

  // The pointers to various types of ReadOnceFile classes that can be stored
  class SetOfHMMs *hmms_data;
  class HMM *hmm_data;

public:
  FileDescriptor(){};
  FileDescriptor(const string &filename, class SetOfHMMs *data);
  FileDescriptor(const string &filename, class HMM *data);
  
  class ReadOnceFile *get_data();
  bool is_upto_date();

private:
  void set_mod_time();
  
};


#endif

/* End of ctk_file_desc.hh */
