/******************************************************************************/
/*									      */
/*	ctk_function_classes.hh	    					      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_FUNCTION_CLASSES_HH
#define CTK_FUNCTION_CLASSES_HH

#include <vector>
#include <functional>

// Function class that deletes its argument
template <class Arg>
class Delete_x :  private unary_function<Arg,void>
{
public:
  Delete_x() {}
  void operator()(const Arg& x){delete(x);}
};

template <class ForwardIterator>
void sequence_delete(ForwardIterator first, ForwardIterator last) {
  while (first != last)
    delete *first++;
}

template <class ForwardIterator>
void map_delete(ForwardIterator first, ForwardIterator last) {
  while (first != last)
    delete (*first++).second;
}


template <class T>
typename vector<T>::iterator find_pointer(typename vector<T>::iterator first,
				   typename vector<T>::iterator last,
				   T x) {
  while (first != last) {
    if (**first==*x)
      return first;
    ++first;
  }
  return first;
}

#endif

