/******************************************************************************/
/*									      */
/*	ctk_lattice.hh	    						      */
/*									      */
/*	Class declarations for ctk_lattice.cpp				      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007		        	      */
/*									      */
/******************************************************************************/

#ifndef CTK_LATTICE_HH
#define CTK_LATTICE_HH

#include <iosfwd>
#include <string>
#include <vector>
#include <sstream>

#include "ctk_decoder.hh"

typedef NodePair NetworkNodePair;

/******************************************************************************/
/*									      */
/*	CLASS NAME: LatticeNode	     				      */
/*									      */
/******************************************************************************/


class LatticeNode {

private:
  int id_;
  string name_;

  bool start_node_;   // True if node is a potential start node - i.e. no arcs enter
  bool end_node_;     // True if node is a potential end node - i.e. no arcs leave
  
public:
  LatticeNode(): id_(0), name_("\0"), start_node_(true), end_node_(true) {};
  LatticeNode(int id, const string &name): id_(id), name_(name), start_node_(true), end_node_(true) {};

  int id() const {return id_;}
  string name() const {return name_;}

  void unsetStartNode() {start_node_=false;}
  void unsetEndNode() {end_node_=false;}

  bool start_node() const {return start_node_;}
  bool end_node() const {return end_node_;}

  friend ostream& operator<< (ostream& out, const LatticeNode& node);
};


/******************************************************************************/
/*									      */
/*	CLASS NAME: LatticeArc     				      */
/*									      */
/******************************************************************************/


class LatticeArc {

private:
  int id_;
  int from_;
  int to_;

public:
  LatticeArc(): id_(0), from_(0), to_(0){};
  LatticeArc(int id, int from, int to): id_(id), from_(from), to_(to){};

  friend ostream& operator<< (ostream& out, const LatticeArc& arc);

  int id() const {return id_;}
  int from() const {return from_;}
  int to() const {return to_;}
};



/******************************************************************************/
/*									      */
/*	CLASS NAME: Lattice	     				      */
/*									      */
/******************************************************************************/


class Lattice {

private:
  
  map<int, LatticeArc> arcs;
  map<int, LatticeNode> nodes;

public:
  
  Lattice(istream &ifstr);
  
  virtual ~Lattice();

  void display();
  
  CTKStatus buildNetwork(Decoder &network, NetworkNodePair node_pair);  // Construct a network to represent this grammar - return true on success else false

private:
  void interpret_line(const string &line);

  bool parse_assignment(std::istringstream &ifstr, string &lhs, string &rhs);
  bool is_comment(std::istringstream &ifstr);
  bool interpret_VERSION(std::istringstream &ifstr, const string &rhs);
  bool interpret_N(std::istringstream &ifstr, const string &rhs);
  bool interpret_I(std::istringstream &ifstr, const string &rhs);
  bool interpret_J(std::istringstream &ifstr, const string &rhs);

  int string_to_int(const string &s);

  CTKStatus find_start_and_end_nodes(int &start_node_id, int &end_node_id) const;
  
  friend ostream& operator<< (ostream& out, const Lattice& lattice);
};



#endif

/* End of ctk_lattice.hh */
