/******************************************************************************/
/*									      */
/*	ctk_local.hh	    						      */
/*									      */
/*	Local definitions for the CTK project:		 		      */
/*	This file must be included at the top of all ctk_xxx.cpp files	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007		         	      */
/*									      */
/******************************************************************************/

#ifndef CTK_LOCAL_HH
#define CTK_LOCAL_HH

#include "ctk-config.h"

#include <iostream>

#ifndef _RWSTD_NO_NAMESPACE
using namespace std;
#endif

//
// Uncomment the following line to compile the code with the probability calculation bugs
// that existed in CTKv1.1.0.
// See comments labeled BUG_1 and BUG_2 in this file and ctk_HMM.cpp respectively.
//
// #define WITH_V1_1_0_BUGS  
//

/******************************************************************************/
/*									      */
/*	Local Type Definitions						      */
/*									      */
/******************************************************************************/

typedef char 		Character;
typedef int 		Boolean;

typedef int 		Integer;
typedef unsigned int 	UInteger;
typedef double 		Float;

typedef char 		Integer8;
typedef short 		Integer16;
typedef int 		Integer32;

typedef unsigned char 	UInteger8;
typedef unsigned short 	UInteger16;
typedef unsigned int 	UInteger32;

typedef enum {CTK_FAILURE, CTK_SUCCESS} CTKStatus;

// The KAI STL has mem_fun rather than mem_fun
#if defined _KCC
#define mem_fun1 mem_fun  
#endif

#if defined _CC
#define mem_fun1 mem_fun  
#endif

/******************************************************************************/
/*									      */
/* CTK CONSTANT DEFINITIONS						      */
/*									      */
/******************************************************************************/

const Integer CTK_CHAR_BUFFER_SIZE = 255;

#ifdef WITH_V1_1_0_BUGS  
const char CTK_VERSION_STRING[] = "CTK v1.3.5 (Apr 22, 2007) [+v1.1.0 ctk_HMM bugs]";
#else
const char CTK_VERSION_STRING[] = "CTK v1.3.5 (Apr 22, 2007)";
#endif

#endif

/* End of  ctk_local.hh */




