/******************************************************************************/
/*									      */
/*	ctk_pipe.cpp	    						      */
/*									      */
/*	Implemenation for Pipe						      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#include "ctk-config.h"
 
#include "ctk_local.hh" 
#include "ctk_pipe.hh"


/******************************************************************************/
/*									      */
/*	CLASS NAME: CircularBufferr	      				      */
/*									      */
/******************************************************************************/


/******************************************************************************/
/*									      */
/*	CLASS NAME: Pipe	         				      */
/*									      */
/******************************************************************************/

Pipe::Pipe(){
  initial_state=false;
  end_of_data=false;
};

//virtual void Pipe::clear(Integer new_size=0)=0;
//virtual Boolean Pipe::primed()=0;
//virtual UInteger Pipe::get_storage() const =0;
//virtual Boolean Pipe::put_back(Integer n) =0;

void Pipe::reset(){end_of_data=false;}   
Boolean Pipe::get_end_of_data() const {return end_of_data;}
Boolean Pipe::is_primed_on_reset() const {return initial_state;}
void Pipe::set_end_of_data() {end_of_data=true;}
void Pipe::make_primed_on_reset() {initial_state=true;}

 
/******************************************************************************/
/*									      */
/*	CLASS NAME: FloatPipe	         				      */
/*									      */
/******************************************************************************/
 

FloatPipe::FloatPipe(Integer nframes/*=1*/) {

  if (nframes<1) nframes=1;
  
  buffer = new CircularBuffer<Float>(nframes);
  
  reset();
};

FloatPipe::~FloatPipe() {
  delete buffer;
}

void FloatPipe::clear(Integer new_size/*=0*/) {buffer->clear(new_size);}

void FloatPipe::reset() { 
  Pipe::reset(); 
  clear();
  if (is_primed_on_reset()) {
    Float x=0.0; put(x);
  }
}

Boolean FloatPipe::primed() {return (buffer->get_storage()!=0);}

UInteger FloatPipe::get_storage() const {return buffer->get_storage();}
Boolean FloatPipe::put_back(Integer n) {return buffer->put_back(n);}

Boolean FloatPipe::get(Float &x) {return buffer->get(x);}
Boolean FloatPipe::put(const Float &x) {return buffer->put(x);}
Boolean FloatPipe::read(vector<Float> &out_data) {return buffer->read(out_data);}
Boolean FloatPipe::write(const vector<Float> &in_data, Integer pos, Integer n) {return buffer->write(in_data, pos, n);}
Integer FloatPipe::flush(vector<Float> &out_data) {return buffer->flush(out_data);}


/******************************************************************************/
/*									      */
/*	CLASS NAME: FramePipe	         				      */
/*									      */
/******************************************************************************/


FramePipe::FramePipe(Integer nframes/*=1*/) {
  
  if (nframes<1) nframes=1;

  buffer = new CircularBuffer<CTKVector*>(nframes);
  reset();
};

FramePipe::~FramePipe() {

  // Destroy any frames left on the buffer
  vector<CTKVector*> stuff;
  buffer->flush(stuff);
  for (UInteger i=0; i<stuff.size(); ++i)
    delete stuff[i];
  
  delete buffer;
}

void FramePipe::clear(Integer new_size/*=0*/) {buffer->clear_and_delete(new_size);}

void FramePipe::reset() { 
  Pipe::reset();
  clear();
  if (is_primed_on_reset()) {
    CTKVector *x=new CTKVector();  // JON JON
    put(x); 
  }
}

Boolean FramePipe::primed() {return (buffer->get_storage()!=0);}
UInteger FramePipe::get_storage() const {return buffer->get_storage();}
Boolean FramePipe::put_back(Integer n) {return buffer->put_back(n);}

Boolean FramePipe::get(CTKVector* &x) {return buffer->get(x);}
Boolean FramePipe::put(CTKVector* x) {return buffer->put(x);}
Boolean FramePipe::read(vector<CTKVector*> &out_data) {return buffer->read(out_data);}
Boolean FramePipe::write(const vector<CTKVector*> &in_data, Integer pos/*=0*/, Integer n/*=0*/) {return buffer->write(in_data, pos, n);}
Integer FramePipe::flush(vector<CTKVector*> &out_data) {return buffer->flush(out_data);}



/* End of ctk_pipe.cpp */
