/******************************************************************************/
/*                                                                            */
/*      ctk_ro_file.cpp                                                       */
/*                                                                            */
/*      Implementation of the read once file                                  */
/*                                                                            */
/*      Author: Jon Barker, Sheffield University                              */
/*                                                                            */
/*      CTK VERSION 1.3.5  Apr 22, 2007                                   */
/*                                                                            */
/******************************************************************************/

#include "ctk-config.h"

#include <string>

#include "ctk_file_desc.hh"
#include "ctk_ro_file.hh"


Boolean ReadOnceFile::interactive_mode_=false;

/******************************************************************************/
/*									      */
/*	CLASS NAME: ReadOnceFile		               	       	      */
/*									      */
/******************************************************************************/

const int MAX_LINE_LENGTH = 1025;

ReadOnceFile::ReadOnceFile(const string &filename):filename_(filename) {
  ro_fp_=fopen(filename.c_str(),"r");
}

ReadOnceFile::~ReadOnceFile() {

}

unsigned int ReadOnceFile::count_lines() {

  char buffer[MAX_LINE_LENGTH+1];
  char read_word_format_string[MAX_LINE_LENGTH+1];
  int n=0;

  sprintf(read_word_format_string,"%%%ds",MAX_LINE_LENGTH);
  while (fscanf(ro_fp_, read_word_format_string, buffer)==1) 
    ++n;
  rewind(ro_fp_);
  return n;
    
}

/******************************************************************************/
/*									      */
/*	File Table                		               	       	      */
/*									      */
/******************************************************************************/

void file_table_add_entry(SetOfHMMs *rof, const string &filename, const string &blockname) {
  file_table_delete_entry(filename, blockname);
  file_table[filename+':'+blockname]=new FileDescriptor(filename, rof);
}  

void file_table_add_entry(HMM *rof, const string &filename, const string &blockname) {
  file_table_delete_entry(filename, blockname);
  file_table[filename+':'+blockname]=new FileDescriptor(filename, rof);
}  



ReadOnceFile *file_table_fetch_entry(const string &filename, const string &blockname, Boolean ignore_timestamp /*=false*/) {
  FileDescriptor *file_descriptor;

  ReadOnceFile *rof=NULL;
  if ((file_descriptor = file_table[filename+':'+blockname]) != NULL) {
    if ((ReadOnceFile::interactive_mode_==false) || (file_descriptor->is_upto_date()) || (ignore_timestamp==true)) {
      rof=file_descriptor->get_data();
    }
  }
  
  return rof;
}

ReadOnceFile *file_table_fetch_entry_ignoring_timestamp(const string &filename, const string &blockname) {
 return file_table_fetch_entry(filename, blockname, true);
}

bool file_table_delete_entry(const string &filename, const string &blockname) {
  FileDescriptor *fd;
  if ((fd=file_table[filename+':'+blockname])!=NULL) {
    delete fd->get_data();
    return true;
  }
  return false;
}


/* End of ctk_ro_file.cpp */
