/******************************************************************************/
/*									      */
/*	ctk_script.hh	         					      */
/*									      */
/*	Class declarations for ctk_script.cpp			              */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			              */
/*									      */
/******************************************************************************/

#ifndef CTK_SCRIPT_HH
#define CTK_SCRIPT_HH

#include <vector>
#include <string>

#include "ctk_local.hh"

/******************************************************************************/
/*									      */
/*	CLASS NAME: CTKScriptElement	      				      */
/*									      */
/******************************************************************************/


class CTKScriptElement {

private:
    
  string my_string;   // The extract of the script
  
  string file_name;   // The file where it came from
  int line_number;    // The line number in that file where it was found
  //
  //
  //
  
public:
  
  CTKScriptElement() {}
  CTKScriptElement(const string &elem):my_string(elem) {}
  CTKScriptElement(const string &elem, const string fname, int line):my_string(elem), file_name(fname), line_number(line){}

  //
  //  Wrappers for string class
  //
  
  int size() const {return my_string.size();}
  Character& operator[](Integer n){return my_string[n];}
  //  const Character& operator[](Integer n) const {return my_string[n];}   // JONJON
  string& operator+=(Character ch){return my_string+=ch;}
  string::size_type find(const string& ss, Integer siz= 0) const {return my_string.find(ss, siz);}
  string& replace(Integer start, Integer len, const string &word){return my_string.replace(start, len,word);}
  friend ostream& operator<< (ostream& out, const CTKScriptElement &x) {return operator<<(out, x.my_string);}

  //
  //
  
  string get_string() const {return my_string;}
  string get_file_name() const {return file_name;}
  int get_line_number() const {return line_number;}
  
  Boolean is_a_comment() const;
  Boolean is_a_help_comment() const;
  Boolean is_blank() const;
  string get_word();
  string get_script_word();
  string get_braces();
  Boolean get_char(char x);
  void strip_whitespace();
  Boolean interpret_assignment(string &s1, string &s2);
  void replace_word(const string &in_word, const string &out_word);
  Boolean interpret_block_parameters(vector<CTKScriptElement*> &assignment_list);


};

Boolean isname(Character c); 

void make_upper(string &s);


#endif

/* End of ctk_script.hh */
