

/******************************************************************************/
/*									      */
/*	ctk_sys_translation_table.cpp	     			              */
/*									      */
/*	"Script token -> Object" translation table for inbuilt CTK blocks     */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007   	         	              */
/*									      */
/******************************************************************************/

/***************** File Input and Output ****************************************************/

register_block(new AlienSampleInputFile("\0"));
register_block(new ASCIISampleInputFile("\0"));
register_block(new AUSampleInputFile("\0"));
register_block(new HTKSampleInputFile("\0"));
register_block(new TIMITSampleInputFile("\0"));
register_block(new NISTSampleInputFile("\0"));
register_block(new RESPITEInputFile("\0"));

register_block(new AlienSampleOutputFile("\0"));
register_block(new ASCIISampleOutputFile("\0"));
register_block(new AUSampleOutputFile("\0"));
register_block(new HTKSampleOutputFile("\0"));
register_block(new RESPITEOutputFile("\0"));


/***************** Signal Generators ********************************************************/

register_block(new ConstantBlock("\0"));
register_block(new ImpulseWaveBlock("\0"));
register_block(new SineWaveBlock("\0"));
register_block(new SquareWaveBlock("\0"));
register_block(new TriangleWaveBlock("\0"));
register_block(new SawtoothWaveBlock("\0"));
register_block(new GlottalWaveBlock("\0"));

register_block(new WhiteNoiseBlock("\0"));
register_block(new GaussianNoiseBlock("\0"));
register_block(new PinkNoiseBlock("\0"));

register_block(new RampBlock("\0"));

/***************** Unary Operators **********************************************************/

// No parameters
register_block(new HalfWaveRectifyBlock("\0"));
register_block(new FullWaveRectifyBlock("\0"));
register_block(new AmpToDBBlock("\0"));
register_block(new DBToAmpBlock("\0"));
register_block(new Log10Block("\0"));
register_block(new LogBlock("\0"));
register_block(new ExpBlock("\0"));
register_block(new LogicalNOTBlock("\0"));

register_block(new SinBlock("\0"));
register_block(new CosBlock("\0"));
register_block(new TanBlock("\0"));
register_block(new AsinBlock("\0"));
register_block(new AcosBlock("\0"));
register_block(new AtanBlock("\0"));
register_block(new SinhBlock("\0"));
register_block(new CoshBlock("\0"));
register_block(new TanhBlock("\0"));

register_block(new FloorBlock("\0"));

register_block(new FloorBlock("\0"));
register_block(new CeilingBlock("\0"));
register_block(new ScaleBlock("\0"));
register_block(new OffsetBlock("\0"));
register_block(new PowerBlock("\0"));
register_block(new SigmoidBlock("\0"));
register_block(new GreaterThanXBlock("\0"));
register_block(new LessThanXBlock("\0"));
register_block(new EqualToXBlock("\0"));
register_block(new NotEqualToXBlock("\0"));
register_block(new FixBlock("\0"));

// Two parameters
register_block(new NormalPDFBlock("\0"));
register_block(new ErfBlock("\0"));

/***************** Binary Operators *********************************************************/

// One parameter
register_block(new ComparatorBlock("\0"));
register_block(new DividerBlock("\0"));

/***************** Data Stream Merging and Splitting ****************************************/

register_block(new AdderBlock("\0"));
register_block(new MultiplierBlock("\0"));
register_block(new LogicalANDBlock("\0"));
register_block(new LogicalORBlock("\0"));
register_block(new MaxBlock("\0"));
register_block(new MinBlock("\0"));
register_block(new TeeBlock("\0"));
register_block(new JoinBlock("\0"));
register_block(new OptionBlock("\0"));
register_block(new SplitBlock("\0"));

/***************** Miscellaneous Operations *************************************************/

register_block(new FramerBlock("\0"));
register_block(new FFTBlock("\0"));
register_block(new SumBlock("\0"));
register_block(new AveragerBlock("\0"));
register_block(new ReducerBlock("\0"));
register_block(new PeakBlock("\0"));
register_block(new FindMaxBlock("\0"));
register_block(new FindMinBlock("\0"));
register_block(new DecimatorBlock("\0"));
register_block(new UpsampleBlock("\0"));
register_block(new FilterBlock("\0"));   
register_block(new DeltaBlock("\0"));   
register_block(new DeltaMaskBlock("\0"));
register_block(new BoundedDeltaBlock("\0"));   
register_block(new IntegratorBlock("\0"));
register_block(new LeakyIntegratorBlock("\0"));
register_block(new DelayBlock("\0"));  
register_block(new OutputBlock("\0")); 

register_block(new ColourMaskBlock("\0")); 
register_block(new MergeGroupsBlock("\0")); 
register_block(new CutGroupsBlock("\0")); 
register_block(new GroupStartEndDetectionBlock("\0"));

register_block(new GammatoneBankBlock("\0"));
register_block(new CorrelatorBlock("\0"));
register_block(new HarmonicRemovalBlock("\0"));
register_block(new SkeletoniseBlock("\0"));
register_block(new MeddisHaircellBlock("\0"));
register_block(new LindemannLocalisationBlock("\0"));

/***************** Noise Estimation and Spectral Subtraction ********************************/

register_block(new StationaryNoiseEstimationBlock("\0"));
register_block(new HirschWANoiseEstimationBlock("\0"));

/***************** Matlab Interface *********************************************************/

#ifdef _HAS_MATLAB
register_block(new MatlabInputBlock("\0"));
register_block(new MatlabOutputBlock("\0"));
register_block(new MatlabProcessBlock("\0"));
#endif

register_block(new MatlabDisplayBlock("\0"));
register_block(new MatlabDisplayFrameBlock("\0"));

/***************** Graphical Display *********************************************************/

register_block(new QFigureBlock("\0"));

/***************** HMM Decoders *********************************************************/

register_block(new HMMDecoderOnlyBlock("\0"));
register_block(new StandardHMMDecoderBlock("\0"));
register_block(new MD_HMMDecoderBlock("\0"));
register_block(new BoundsUD_HMMDecoderBlock("\0"));
register_block(new PMC_HMMDecoderBlock("\0"));

register_block(new MS_HMMDecoderBlock("\0"));
register_block(new MSSoft_HMMDecoderBlock("\0"));

/***************** Contributed Blocks *********************************************************/

register_block(new AcgPitchBlock("\0"));
register_block(new FilterColourBlock("\0"));
register_block(new TrackerBlock("\0"));

register_block(new GMaskBlock("\0"));
register_block(new AdaptiveNoiseEstimationBlock("\0"));

//register_block(new CTK_Impute("\0"));

/***********************************************************************************************/

//register_block(new Block("\0"));

/* End of ctk_sys_translation_table.cpp */
 
