//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/**
 * @author 	S. Tokumine
 * @date	11-Sep-2003
 * @time	00:35:09
 * @file	HTMLPanel.java
 * 
 * @desc Prints out an HTML file to a textbox, preserfving formatting etc - good for help type things
 * like this!
 *
 */

public class HTMLPanel extends JPanel implements HyperlinkListener {

	JEditorPane editorPane;
	URL helpPage;
	private JScrollPane scrollPane;

	/**
	 * constructos opens the readme.html page and sets the editor pane to use it
	 * also sets up hyperlink ability
	 */
	public HTMLPanel() {
		super();
		helpPage = HTMLPanel.class.getResource("resources/readme.html");

		try {
			editorPane = new JEditorPane(helpPage);
		} catch (IOException e) {
			e.printStackTrace();
		}
		editorPane.setEditable(false);
		scrollPane = new JScrollPane(editorPane);
		scrollPane.setPreferredSize(new Dimension(545, 440));
		editorPane.setEditable(false);
		editorPane.addHyperlinkListener(this);

		this.add(scrollPane);

	}

	/**
	 * responds to hyperlinklisterer events by updating the editor pane with 
	 * the page at the link specified - as we are using internal links, this
	 * just shifts the page
	 * @see javax.swing.event.HyperlinkListener#hyperlinkUpdate(javax.swing.event.HyperlinkEvent)
	 */
	public void hyperlinkUpdate(HyperlinkEvent e) {
		if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
			try {
				editorPane.setPage(e.getURL());
			} catch (IOException ioe) {
			}
		}
	}
}