//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * @author 	S. Tokumine
 * @date	24-Jun-2003
 * @time	00:30:39
 * @file	MainPanel.java
 * 
 * @desc MAinpanel contains all 4 2d images - keys and displays
 * it also manages mouse control over each
 *
 */
public class MainPanel
	extends JPanel
	implements MouseMotionListener, MouseListener {

	ImagePanel heightPanel = new ImagePanel();
	ImagePanel freqPanel = new ImagePanel();
	ImagePanel keyPanelP = new ImagePanel();
	ImagePanel keyPanelF = new ImagePanel();
	JPanel fitSet = new JPanel();
	JPanel popSet = new JPanel();
	JLabel fitness, population, key;
	JPanel keyP;
	JPanel keyF;
	ScoreMapFactory scoreMapFactory; //to change SSM layout
	SlidePanel slidePanel; //to trigger a redraw after shifting

	/**
	 *Constructor sets up borders and new Image Panels 
	 */
	public MainPanel(ScoreMapFactory scoreMapFactory_in) {

		//Add border around the main panel.
		setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));

		scoreMapFactory = scoreMapFactory_in;
		heightPanel.setScoreFact(scoreMapFactory_in);
		freqPanel.setScoreFact(scoreMapFactory_in);

		fitSet.setBorder(
			BorderFactory.createCompoundBorder(
				BorderFactory.createTitledBorder("Fitness (3D Height): "),
				BorderFactory.createEmptyBorder(5, 5, 5, 5)));

		popSet.setBorder(
			BorderFactory.createCompoundBorder(
				BorderFactory.createTitledBorder(
					"Population Density (3D Texture): "),
				BorderFactory.createEmptyBorder(5, 5, 5, 5)));

		//Size and Add image panels to main panel
		setLayout(new FlowLayout(FlowLayout.CENTER, 5, 0));
		fitSet.setLayout(new FlowLayout(FlowLayout.CENTER, 19, 0));
		popSet.setLayout(new FlowLayout(FlowLayout.CENTER, 21, 0));

		//FITNESS label and IMAGE BOX
		fitness = new JLabel("Fitness", JLabel.CENTER);
		fitness.setOpaque(true);
		fitness.setFont(new Font("SansSerif", Font.PLAIN, 15));
		fitness.setPreferredSize(new Dimension(100, 35));

		heightPanel.setPreferredSize(new Dimension(160 - 32, 288 - 32));

		JPanel fitnessP = new JPanel();
		fitnessP.add(heightPanel, BorderLayout.PAGE_START);
		fitnessP.add(fitness, BorderLayout.PAGE_END);
		fitnessP.setPreferredSize(new Dimension(160 - 32, 288 - 32 + 38));

		fitSet.add(fitnessP);

		//Key fitness label and IMAGE BOX
		key = new JLabel("Key", JLabel.LEFT);
		key.setOpaque(true);
		key.setFont(new Font("SansSerif", Font.PLAIN, 15));
		key.setPreferredSize(new Dimension(50, 35));

		keyPanelF.setPreferredSize(new Dimension(20, 288 - 32));

		//key labels for large population small population
		JLabel largePop = new JLabel("High");
		largePop.setOpaque(true);
		largePop.setFont(new Font("SansSerif", Font.PLAIN, 10));
		largePop.setPreferredSize(new Dimension(25, 10));

		JLabel lowPop = new JLabel("Low");
		lowPop.setOpaque(true);
		lowPop.setFont(new Font("SansSerif", Font.PLAIN, 10));
		lowPop.setPreferredSize(new Dimension(25, 450));

		JPanel keyLabel = new JPanel();
		keyLabel.add(largePop, BorderLayout.PAGE_START);
		keyLabel.add(lowPop, BorderLayout.PAGE_END);
		keyLabel.setPreferredSize(new Dimension(25, 288 - 32));

		//add all bits of key together
		keyF = new JPanel();
		keyF.add(keyPanelF, BorderLayout.PAGE_START);
		keyF.add(keyLabel, BorderLayout.EAST);
		keyF.add(key, BorderLayout.PAGE_END);
		keyF.setPreferredSize(new Dimension(60, 288 - 32 + 38));

		fitSet.add(keyF);

		//POPULATION label and IMAGE BOX
		population = new JLabel("Population", JLabel.CENTER);
		population.setOpaque(true);
		population.setFont(new Font("SansSerif", Font.PLAIN, 15));
		population.setPreferredSize(new Dimension(100, 35));

		freqPanel.setPreferredSize(new Dimension(160 - 32, 288 - 32));

		JPanel populationP = new JPanel();
		populationP.add(freqPanel, BorderLayout.PAGE_START);
		populationP.add(population, BorderLayout.PAGE_END);
		populationP.setPreferredSize(new Dimension(160 - 32, 288 - 32 + 38));

		popSet.add(populationP);

		//Key label and IMAGE BOX
		key = new JLabel("Key", JLabel.LEFT);
		key.setOpaque(true);
		key.setFont(new Font("SansSerif", Font.PLAIN, 15));
		key.setPreferredSize(new Dimension(50, 35));

		keyPanelP.setPreferredSize(new Dimension(20, 288 - 32));

		//key labels for large population small population
		JLabel largePop1 = new JLabel("High");
		largePop1.setOpaque(true);
		largePop1.setFont(new Font("SansSerif", Font.PLAIN, 10));
		largePop1.setPreferredSize(new Dimension(25, 10));

		JLabel lowPop1 = new JLabel("Low");
		lowPop1.setOpaque(true);
		lowPop1.setFont(new Font("SansSerif", Font.PLAIN, 10));
		lowPop1.setPreferredSize(new Dimension(25, 450));

		JPanel keyLabel1 = new JPanel();
		keyLabel1.add(largePop1, BorderLayout.PAGE_START);
		keyLabel1.add(lowPop1, BorderLayout.PAGE_END);
		keyLabel1.setPreferredSize(new Dimension(25, 288 - 32));

		//add all bits of key together
		keyP = new JPanel();
		keyP.add(keyPanelP, BorderLayout.WEST);
		keyP.add(keyLabel1, BorderLayout.EAST);
		keyP.add(key, BorderLayout.SOUTH);
		keyP.setPreferredSize(new Dimension(55, 288 - 32 + 38));

		popSet.add(keyP);

		//set up splash images inside windows for start
		URL fitMainURL = MainPanel.class.getResource("resources/fitmain.jpg");
		URL fitKeyURL = MainPanel.class.getResource("resources/fitkey.jpg");
		URL popMainURL = MainPanel.class.getResource("resources/popmain.jpg");
		URL popKeyURL = MainPanel.class.getResource("resources/popkey.jpg");

		Toolkit toolkit = Toolkit.getDefaultToolkit();
		heightPanel.SetImage(toolkit.getImage(fitMainURL));
		keyPanelF.SetImage(toolkit.getImage(fitKeyURL));
		freqPanel.SetImage(toolkit.getImage(popMainURL));
		keyPanelP.SetImage(toolkit.getImage(popKeyURL));

		//Finally add each set to the mainpanel and display
		add(fitSet);
		add(popSet);
	}

	/**
	 * linker mathod - dirty
	 * @param slidePanel_in
	 */
	public void setSlider(SlidePanel slidePanel_in) {
		slidePanel = slidePanel_in;
	}

	/**
	 * initialises the mouse listeners and their actions
	 * the listeners detect draggs within the panel and move the 
	 * SSM accordingly
	 *
	 */
	public void initMovement() {
		//add mouse listeners to the height and density panels
		heightPanel.addMouseListener(this);
		freqPanel.addMouseListener(this);

		//add mouse motion listeners to the height and density panels
		heightPanel.addMouseMotionListener(this);
		freqPanel.addMouseMotionListener(this);

		//make pretty
		heightPanel.setCursor(new Cursor(Cursor.HAND_CURSOR));
		freqPanel.setCursor(new Cursor(Cursor.HAND_CURSOR));

		heightPanel.setToolTipText("Click & Drag to scroll the landscape");
		freqPanel.setToolTipText("Click & Drag to scroll the landscape");
	}

	/**
	 * takes in fitness and density images and sets them up
	 * @param height - fitness
	 * @param freq - population density
	 */
	public void setImage(Image height, Image freq) {
		heightPanel.SetImage(height);
		freqPanel.SetImage(freq);
	}

	/**
	 * sets the population density key
	 * @param key
	 */
	public void setKeyP(Image key) {
		keyPanelP.SetImage(key);
	}

	/**
	 * sets the fitness image key
	 * @param key
	 */
	public void setKeyF(Image key) {
		keyPanelF.SetImage(key);
	}

	/** 
	 * on the mouse drag, increment the counters in each panel, 
	 * and reset the clicked coordinate
	 */
	public void mouseDragged(MouseEvent e) {

		//x axis
		heightPanel.incrementX(e.getX());
		freqPanel.incrementX(e.getX());

		//y axis
		heightPanel.incrementY(e.getY());
		freqPanel.incrementY(e.getY());

		//reset clicked
		heightPanel.setClicked(e.getX(), e.getY());
		freqPanel.setClicked(e.getX(), e.getY());
	}

	/* 
	 * not used
	 */
	public void mouseMoved(MouseEvent e) {
	}

	/* 
	 * not used
	 */
	public void mouseClicked(MouseEvent e) {
	}

	/* 
	* not used
	*/
	public void mouseEntered(MouseEvent e) {
	}

	/* 
	 * not used
	 */
	public void mouseExited(MouseEvent e) {
	}

	/**
	 * expanded so that on click - sets click,
	 * and also changes cursor
	 */
	public void mousePressed(MouseEvent e) {

		heightPanel.setClicked(e.getX(), e.getY());
		freqPanel.setClicked(e.getX(), e.getY());
		heightPanel.setCursor(new Cursor(Cursor.MOVE_CURSOR));
		freqPanel.setCursor(new Cursor(Cursor.MOVE_CURSOR));
	}

	/** 
	 * resets counters and cursors
	 */
	public void mouseReleased(MouseEvent e) {

		scoreMapFactory.setZero();
		heightPanel.setCursor(new Cursor(Cursor.HAND_CURSOR));
		freqPanel.setCursor(new Cursor(Cursor.HAND_CURSOR));
	}
}
