//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.util.ArrayList;

/**
 * @author 	S. Tokumine
 * @date	22-Jun-2003
 * @time	20:55:25
 * @file	SliceList.java
 * 
 * @desc 	Array List holding all the timeslices. Supporting 
 * 			best speed random access
 *
 */
public class SliceList extends ArrayList {

	TextPanel textPanel; //text output
	ColorMapFactory colorMapFactory; //pallette generator
	ScoreMapFactory scoreMapFactory; //ssm generator

	/**
	 * @param arg0 initial size of list. 
	 */
	public SliceList(
		int arg0,
		TextPanel textPanel_in,
		ColorMapFactory colorMapFactory_in,
		ScoreMapFactory scoreMapFactory_in) {
		super(arg0); //Initial size of ArrayList
		textPanel = textPanel_in;
		colorMapFactory = colorMapFactory_in;
		scoreMapFactory = scoreMapFactory_in;
	}

	/**
	 * Access method to add timesteps
	 * @param freqlist details to add
	 * @param slice actual time index
	 */
	public void addSlice(int[] freqList, int slice) {
		add(slice, new Timeslice(freqList, colorMapFactory, scoreMapFactory));
	}

	/**
	 * Access method to get timesteps
	 * @param slice
	 * @return
	 */
	public Timeslice getSlice(int slice) {

		if (get(slice) != null) {
			return (Timeslice) get(slice);
		} else {
			return null;
		}

	}

	/**
	 * All print out of fields
	 */
	public void printAll(String fileName) {

		textPanel.print("==XML file \"" + fileName + "\" ==");

		for (int i = 0; i < size(); i++) {

			Timeslice temp = (Timeslice) get(i);
			textPanel.print("==Slice " + i + " ==");
			temp.printAll(textPanel);
			textPanel.print("==Slice " + i + " ==\n\n");

		}
	}

	/**
	* All print out of fields
	*/
	public void printSlice(int i) {
		try {
			Timeslice temp = (Timeslice) get(i);
			textPanel.print("==Slice " + i + " printout==");
			temp.printAll(textPanel);
			textPanel.print("==Slice " + i + " printout==\n\n");
		} catch (IndexOutOfBoundsException IOE) {

		}
	}
}
