/*
 *      TeVi.java       
 *
 *      Terrain Visualization Applet/Application
 *
 */

import java.awt.*;
import java.awt.image.*;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.*;

import javax.media.j3d.*;
import javax.swing.JPanel;
import javax.vecmath.*;

public class TeVi extends JPanel {

	//=== VARIABLES =====================================================================================

	private String[][] AppletInfo =
		{ { "Texture", "String", "Terrain texture file" }, {
			"HeightField", "String", "height values, grayscale" }, {
			"SelectionMap", "String", "map to select from" }, {
			"NumTilesX", "int", "nr. of Tiles (horizontal)" }, {
			"NumTilesY", "int", "nr. of Tiles (vertical)" }, {
			"ROIWidth", "int", "width of ROI selected map" }
	};

	private Image LoadImage = null; // image containing height values
	private Image tempImage = null;
	private Image temptex = null;
	private Texture2D Texture = null; // texture

	private int[] HeightMap; // array of height values
	private int Width; // width and height of height map

	private static int NumTilesX = -1; // for region of interest selection
	private static int NumTilesY = -1; // num. of tiles in x,y direction
	private static int ROIWidth = 0; // w/h of ROI height map

	private static String TextureFile = "Default_TexMap.png";
	// texture file name
	private static String HeightFile = "Default_HeightMap.png";
	// height values file name
	private static String MapFile = null; // map of region file name

	private SimpleUniverse SimpleU = null; // a Convenience Utility class
	private BranchGroup ObjRoot = null; // top BG in SimpleU's geom. branch
	private BranchGroup NavRoot = null; // BG for Key-/MouseBehavior
	private BoundingLeaf AlwaysOnBoundingLeaf = null;
	// to make naviagtion always active

	private TMouseBehavior MouseBeh; // mouse navigation

	private SlidePanel slidePanel; //way into tevi
	private Image changeHeight = null;
	private Image changeTexture = null;
	Terrain terrain;

	//=== METHODS =======================================================================================

	public TeVi(
		Image HeightMap_in,
		Image texture_in,
		SlidePanel slidePanel_in) {
		tempImage = HeightMap_in;
		temptex = texture_in;
		slidePanel = slidePanel_in;
		slidePanel.setTevi(this);
		init();
		this.show();
	}

	public void terrainChange(Image heightMap_in, Image texture_in) {
		changeHeight = heightMap_in;
		changeTexture = texture_in;
		changeTerrain();
//		slidePanel.playTimer.setChanged(true);
	}

	public void init() {

		VirtualUniverse.setJ3DThreadPriority(4);

		//--- configure 3D canvas -----------------------------------------------------------------

		setLayout(new BorderLayout());

		GraphicsConfigTemplate3D gctTmpl = new GraphicsConfigTemplate3D();
		GraphicsEnvironment gEnv =
			GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice gDevice = gEnv.getDefaultScreenDevice();
		GraphicsConfiguration gConfig = gDevice.getBestConfiguration(gctTmpl);
		Canvas3D canvas3D = new Canvas3D(gConfig);

		canvas3D.setSize(getWidth(), getHeight());
		canvas3D.setStereoEnable(true);
		add(BorderLayout.CENTER, canvas3D);

		//--- setup 2 BranchGroups ----------------------------------------------------------------

		SimpleU = new SimpleUniverse(canvas3D);
		ObjRoot = new BranchGroup();
		NavRoot = new BranchGroup();

		ObjRoot.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
		ObjRoot.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		NavRoot.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
		NavRoot.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		SimpleU.addBranchGraph(ObjRoot);
		SimpleU.addBranchGraph(NavRoot);

		//--- create an "always on"-bounding leaf -------------------------------------------------

		AlwaysOnBoundingLeaf =
			new BoundingLeaf(new BoundingSphere(new Point3d(), 100000));
		PlatformGeometry platformGeom = new PlatformGeometry();

		platformGeom.addChild(AlwaysOnBoundingLeaf);
		platformGeom.compile();

		SimpleU.getViewingPlatform().setPlatformGeometry(platformGeom);

		//--- add basic mouse navigation ----------------------------------------------------------

		BranchGroup mbg = new BranchGroup();
		MouseBeh = new TMouseBehavior();

		MouseBeh.setSchedulingBoundingLeaf(AlwaysOnBoundingLeaf);
		mbg.addChild(MouseBeh);
		NavRoot.addChild(mbg);

		//--- region selection? -------------------------------------------------------------------

//		if ((MapFile == null) && (NumTilesX == -1)) {
//			MapFile = getParameter("SelectionMap");
//		}

		if (MapFile != null) {
			selectROI();
		} else {
			initTerrain();
		}
	}

	private void selectROI() {
//
//		//--- set up map plane geometry ----------------------------------------------------
//
//		QuadArray plane =
//			new QuadArray(
//				4,
//				GeometryArray.COORDINATES | GeometryArray.TEXTURE_COORDINATE_2);
//
//		float aspectRatio = (float) getWidth() / (float) getHeight();
//
//		Point3f p = new Point3f();
//		p.set(-1.0f, 1.0f / aspectRatio, 0.0f);
//		plane.setCoordinate(0, p);
//		p.set(-1.0f, -1.0f / aspectRatio, 0.0f);
//		plane.setCoordinate(1, p);
//		p.set(1.0f, -1.0f / aspectRatio, 0.0f);
//		plane.setCoordinate(2, p);
//		p.set(1.0f, 1.0f / aspectRatio, 0.0f);
//		plane.setCoordinate(3, p);
//
//		TexCoord2f q = new TexCoord2f();
//		q.set(0.0f, 1.0f);
//		plane.setTextureCoordinate(0, 0, q);
//		q.set(0.0f, 0.0f);
//		plane.setTextureCoordinate(0, 1, q);
//		q.set(1.0f, 0.0f);
//		plane.setTextureCoordinate(0, 2, q);
//		q.set(1.0f, 1.0f);
//		plane.setTextureCoordinate(0, 3, q);
//
//		//--- load world map texture  ------------------------------------------------------
//
//		LoadImage = getImage(getCodeBase(), MapFile);
//		TextureLoader texLoader = new TextureLoader(LoadImage, this);
//		ImageComponent2D ic2d = texLoader.getImage();
//		Texture2D texture =
//			new Texture2D(
//				Texture.BASE_LEVEL,
//				Texture.RGB,
//				ic2d.getWidth(),
//				ic2d.getHeight());
//		texture.setImage(0, ic2d);
//		texture.setEnable(true);
//		texture.setMinFilter(Texture.NICEST);
//		texture.setMagFilter(Texture.NICEST);
//
//		//--- set up map plane appearance --------------------------------------------------
//
//		Appearance appear = new Appearance();
//
//		appear.setTexture(texture);
//
//		//--- display the map --------------------------------------------------------------
//
//		Shape3D planeObj = new Shape3D(plane, appear);
//		BranchGroup mapRoot = new BranchGroup();
//
//		mapRoot.setCapability(BranchGroup.ALLOW_DETACH);
//		mapRoot.addChild(planeObj);
//		mapRoot.compile();
//
//		ObjRoot.addChild(mapRoot);
//		SimpleU.getViewingPlatform().setNominalViewingTransform();
//
//		//--- start ROI selection mode -----------------------------------------------------
//
//		MouseBeh.setSelectROIMode(this);
	}

	public void selectROI2(int selX, int selY) {
//
//		//--- determine maine file to be loaded ----------------------------------------------
//
//		if (NumTilesX == -1) {
//			NumTilesX = Integer.parseInt(getParameter("NumTilesX"));
//		}
//		if (NumTilesY == -1) {
//			NumTilesY = Integer.parseInt(getParameter("NumTilesY"));
//		}
//
//		int tileWidth = getWidth() / NumTilesX;
//		int tileHeight = getHeight() / NumTilesY;
//
//		int tileX = Math.min((selX / tileWidth) + 1, NumTilesX);
//		int tileY = Math.min((selY / tileHeight) + 1, NumTilesY);
//
//		HeightFile = createFileName(tileX, tileY);
//
//		//--- load selected height file ------------------------------------------------------
//
//		loadHeightData(HeightFile);
//
//		int picW = Width;
//		int picH = Width;
//
//		//--- determine width/height of COMPLETE height data set -----------------------------
//
//		int complW = picW * NumTilesX;
//		int complH = picH * NumTilesY;
//
//		if (ROIWidth == 0) {
//
//			ROIWidth = checkWidth(Integer.parseInt(getParameter("ROIWidth")));
//		}
//
//		if (ROIWidth > Math.min(complW, complH)) {
//
//			ROIWidth = checkWidth(Math.min(complW, complH));
//		}
//
//		//--- determine center pixel coordinates ---------------------------------------------
//
//		int centerX = complW * selX / getWidth();
//		int centerY = complH * selY / getHeight();
//		int rw2 = ROIWidth / 2;
//
//		if (centerX < rw2) {
//			centerX = rw2;
//		}
//		if (centerY < rw2) {
//			centerY = rw2;
//		}
//		if (centerX > complW - 1 - rw2) {
//			centerX = complW - 1 - rw2;
//		}
//		if (centerY > complH - 1 - rw2) {
//			centerY = complH - 1 - rw2;
//		}
//
//		//--- determine TL and BR tile to be loaded ------------------------------------------
//
//		int left = (centerX - rw2) / picW + 1;
//		int right = (centerX + rw2) / picW + 1;
//		int top = (centerY - rw2) / picH + 1;
//		int bottom = (centerY + rw2) / picH + 1;
//
//		//--- load all files -----------------------------------------------------------------
//
//		HeightMap = new int[ROIWidth * ROIWidth];
//
//		int pixY = centerY - rw2;
//		int nextY = picH * top - 1;
//
//		for (int y = top; y <= bottom; y++) {
//
//			int pixX = centerX - rw2;
//			int nextX = picW * left - 1;
//
//			for (int x = left; x <= right; x++) {
//
//				loadHeightData(createFileName(x, y));
//
//				if (nextX > centerX + rw2) {
//					nextX = centerX + rw2;
//				}
//				if (nextY > centerY + rw2) {
//					nextY = centerY + rw2;
//				}
//
//				grabPixels(
//					LoadImage,
//					pixX % picW,
//					pixY % picH,
//					nextX - pixX + 1,
//					nextY - pixY + 1,
//					HeightMap,
//					(pixY - (centerY - rw2)) * ROIWidth
//						+ (pixX - (centerX - rw2)),
//					ROIWidth);
//
//				pixX = nextX + 1;
//				nextX += picW;
//			}
//
//			pixY = nextY + 1;
//			nextY += picH;
//		}
//
//		for (int i = 0; i < HeightMap.length; i++) {
//			HeightMap[i] &= 0xff;
//		}
//
//		Width = ROIWidth;
//
//		//--- flight -------------------------------------------------------------------------
//
//		ObjRoot.removeChild(0);
//
//		TextureFile = null;
//
//		initTerrain();
	}

	private String createFileName(int x, int y) {

		// strings of numbers should be at least 3 digits long

		String sx, sy;

		if (x < 10) {
			sx = "00" + x;
		} else if (x < 100) {
			sx = "0" + x;
		} else {
			sx = "" + x;
		}

		if (y < 10) {
			sy = "00" + y;
		} else if (y < 100) {
			sy = "0" + y;
		} else {
			sy = "" + y;
		}

		return "HeightMap_" + sx + "_" + sy + ".png";
	}

	private void loadHeightData(String hFile) {

		//--- load height file -------------------------------------------------

		TextureLoader texLoader = null;
		ImageComponent2D ic2d = null;

		LoadImage = tempImage; //getImage(getCodeBase(), hFile);
		texLoader = new TextureLoader(LoadImage, this);
		ic2d = texLoader.getImage();
		Width = checkWidth(Math.min(ic2d.getWidth(), ic2d.getHeight()));
	}

	private void grabPixels(
		Image img,
		int x,
		int y,
		int w,
		int h,
		int[] pix,
		int off,
		int scansize) {

		PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pix, off, scansize);

		try {
			pg.grabPixels();
		} catch (InterruptedException e) {

			System.err.println("interrupted waiting for pixels!");
		}
	}

	private void initTerrain() {

		//--- determine files to be loaded -----------------------------------------------------

//		if (TextureFile == null) {
//			TextureFile = getParameter("Texture");
//		}
//		if (HeightFile == null) {
//			HeightFile = getParameter("HeightField");
//		}

		//--- (select and) load height data ----------------------------------------------------

		if (HeightMap == null) {

			loadHeightData(HeightFile);

			//--- fill array with height values --------------------------------------

			HeightMap = new int[Width * Width];

			grabPixels(LoadImage, 0, 0, Width, Width, HeightMap, 0, Width);

			for (int i = 0; i < HeightMap.length; i++) {
				HeightMap[i] &= 0xff;
			}
		}

		//--- load TextureMap ------------------------------------------------------------------

		if (TextureFile != null) {

			TextureLoader texLoader = null;
			ImageComponent2D ic2d = null;

			LoadImage = temptex; //getImage(getCodeBase(), TextureFile);
			texLoader = new TextureLoader(LoadImage, this);
			ic2d = texLoader.getImage();
			Texture =
				new Texture2D(
					Texture.BASE_LEVEL,
					Texture.RGB,
					ic2d.getWidth(),
					ic2d.getHeight());

			Texture.setImage(0, ic2d);
			Texture.setEnable(true);
			Texture.setMinFilter(Texture.NICEST);
			Texture.setMagFilter(Texture.NICEST);
		}

		//--- create SceneGraph ----------------------------------------------------------------

		BranchGroup scene = createSceneGraph(SimpleU);

		ObjRoot.addChild(scene);

		HeightMap = null;
	}

	private void changeTerrain() {

		//--- determine files to be loaded -----------------------------------------------------

		//		if (TextureFile == null) {
		//			TextureFile = getParameter("Texture");
		//		}
		//		if (HeightFile == null) {
		//			HeightFile = getParameter("HeightField");
		//		}

		//--- (select and) load height data ----------------------------------------------------

		//if (HeightMap == null) {

		//		loadHeightData(HeightFile);

		//--- fill array with height values --------------------------------------

		HeightMap = new int[Width * Width];

		grabPixels(changeHeight, 0, 0, Width, Width, HeightMap, 0, Width);

		for (int i = 0; i < HeightMap.length; i++) {
			HeightMap[i] &= 0xff;
		}
		//	}

		//--- load TextureMap ------------------------------------------------------------------

		//	if (TextureFile != null) {

		TextureLoader texLoader = null;
		ImageComponent2D ic2d = null;

		LoadImage = changeTexture; //getImage(getCodeBase(), TextureFile);
		texLoader = new TextureLoader(LoadImage, this);
		ic2d = texLoader.getImage();
		Texture =
			new Texture2D(
				Texture.BASE_LEVEL,
				Texture.RGB,
				ic2d.getWidth(),
				ic2d.getHeight());

		Texture.setImage(0, ic2d);
		Texture.setEnable(true);
		Texture.setMinFilter(Texture.NICEST);
		Texture.setMagFilter(Texture.NICEST);
		//	}

		//--- By this point ought to have texture and height maps----------------------------------------------------------------
		//	System.out.println("rocking");
		terrain.changeTerrain(
			HeightMap,
			Texture,
			0.0f,
			0.0f,
			30.0f / (float) Width,
			15.0f);
	}

	private int checkWidth(int w) {

		int possibleW = 3; // 0, 3, 5, 9, 17, 33, 65, 129, 257, ...

		if (w < 3)
			return 0;

		while (w > possibleW) {
			possibleW = (2 * possibleW) - 1;
		}

		if (w == possibleW)
			return possibleW;
		else /*(w <  possibleW)*/
			return (possibleW + 1) / 2;
	}

	private BranchGroup createSceneGraph(SimpleUniverse su) {

		//--- Create the root of the branch graph ----------------------------------------------

		BranchGroup terRoot = new BranchGroup();
		TransformGroup vpTrans =
			su.getViewingPlatform().getViewPlatformTransform();

		//--- set initial viewpoint ------------------------------------------------------------

		Transform3D t3d = new Transform3D();

		t3d.lookAt(
			new Point3d(15, 15, 15),
			new Point3d(),
			new Vector3d(0, 1, 0));
		t3d.invert();
		vpTrans.setTransform(t3d);

		//--- Create a terrain leaf node, add it to the scene graph ----------------------------

		terrain =
			new Terrain(
				su,
				HeightMap,
				Texture,
				0.0f,
				0.0f,
				30.0f / (float) Width,
				15.0f);
		//used to be 3.0f, change to 10.0f

		terRoot.addChild(terrain);

		//--- add a background color -----------------------------------------------------------

		BranchGroup back = new BranchGroup(); // Background's BranchGroup
		Background background = new Background(new Color3f(Color.WHITE));

		background.setApplicationBoundingLeaf(AlwaysOnBoundingLeaf);

		back.addChild(background);
		back.compile();

		terRoot.addChild(back);

		//--- setup mouse navigation -----------------------------------------------------------

		MouseBeh.setup(vpTrans, 0.008f, false);

		//--- add keyboard navigation ----------------------------------------------------------

		BranchGroup kbg = new BranchGroup();
		TKeyBehavior keyBeh = new TKeyBehavior(terrain, 0.5f);

		keyBeh.setSchedulingBoundingLeaf(AlwaysOnBoundingLeaf);
		kbg.addChild(keyBeh);
		NavRoot.addChild(kbg);

		//--- add View Updater -----------------------------------------------------------------

		TEachFrameBehavior efBeh =
			new TEachFrameBehavior(terrain, vpTrans, keyBeh, MouseBeh);

		efBeh.setSchedulingBoundingLeaf(AlwaysOnBoundingLeaf);
		terRoot.addChild(efBeh);

		//SIMON TOKUMINE - TRY TO ADD LIGHTS...

		//		AmbientLight amb = new AmbientLight(new Color3f(1.0f,1.0f,1.0f));
		//		amb.setInfluencingBounds(new BoundingSphere());
		//		vpTrans.addChild(amb);
		//		               
		//	               
		//		// Create the directional light
		//		Color3f white = new Color3f(1.0f,  1.0f,  1.0f);
		//		Vector3f dir = new Vector3f(-1.0f, -1.0f, -1.0f);
		//		DirectionalLight dirLight = new DirectionalLight(white, dir);
		//		dirLight.setInfluencingBounds(new BoundingSphere());
		//		vpTrans.addChild(dirLight);

		//simon tokumine add lights?
//		BoundingSphere bounds = new BoundingSphere();
//		// the render will only light objects inside this volume
//		bounds.setRadius(1000.0);
//
//		// add a light so we can see the sphere
//		DirectionalLight lightD = new DirectionalLight();
//		lightD.setInfluencingBounds(bounds);
//		lightD.setDirection(new Vector3f(.7f, -.7f, -.7f));
//		lightD.setColor(new Color3f(3.0f,1.0f,3.0f));
//		// point the light right, down, into the screen
//		terRoot.addChild(lightD);

		terRoot.compile();

		return terRoot;
	}

	public String getAppletInfo() {

		return "TeVi v. 0.5,  written by Martin Barbisch 2002";
	}

	public String[][] getParameterInfo() {

		return AppletInfo;
	}

	public void destroy() {

		SimpleU.removeAllLocales();
	}

	//--- The following allows this to be run as an application as well as an applet -----

	/*       public static void main(String[] args) {
	
	              //--- get command line arguments -------------------------------------------
	
	               if (args.length >= 3) {
	
	                       MapFile   = args[0];
	                       NumTilesX = Integer.parseInt(args[1]);
	                       NumTilesY = Integer.parseInt(args[2]);
	
	                       if (args.length >= 4) {  ROIWidth = Integer.parseInt(args[3]);  }
	                       else                  {  ROIWidth = 129;                        }
	               }
	               else {
	                       NumTilesX = NumTilesY = 0;
	
	                       if (args.length >= 1) {  HeightFile  = args[0];  }
	                       if (args.length >= 2) {  TextureFile = args[1];  }
	               }
	
	
	              //--- set unspecified variables to default ---------------------------------
	
	               if (HeightFile  == null) {  HeightFile  = "Default_HeightMap.png";  }
	               if (TextureFile == null) {  TextureFile = "Default_TexMap.png";     }
	
	
	              //--- start the program ----------------------------------------------------
	
	               Frame frame = new MainFrame(new TeVi(), 512, 512);
	       }
	       */
}
