// EPDExperimentSwarm.h EPD
//Copyright James Marshall 1998-2004. Freely distributable under the GNU General Public Licence

#import "EPDSwarm.h"

#import <gui.h>
#import <simtoolsgui.h>
#import <simtoolsgui/GUISwarm.h>
#import <analysis.h>

@interface ParameterManager: SwarmObject
{
  double movementProbability, moveProbInc, moveProbMax;
  int runNumber, runNumberMax;

  id pmProbeMap;
}

- initializeParameters;
- initializeModel: (id)theModel;
- stepParameters;
- printParameters: anOutFile;

@end

@interface EPDExperimentSwarm: GUISwarm
{
  int modelTime, averageCooperation, averageRelatedness, numModelRuns;
  double averageInteractionLength, averageCellPopulation, averageNumberOfPartners;

  id modelProbeMap;
  id displayActions;
  id displaySchedule;
  id epdSwarm, parameterManager, logFile;

//  EZGraph *resultGraph;
}

+createBegin: (id) aZone;
-createEnd;

-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end
