//EPDWorld.h EPD
//Copyright James Marshall 1998-2004. Freely distributable under the GNU General Public Licence

#import <space.h>
#import <collections.h>
#import <random.h>
#import <objectbase/SwarmObject.h>
#import <analysis.h>
#import <space/Discrete2d.h>
#import "EPDDefines.h"
#import "IntegerData.h"
#import "DoubleData.h"

//#define debug

@interface EPDWorld : Discrete2d
{
  int maxAgents, maxLocalAgents, startAgents, strategyLength, strategyNumber, cooperativeActions, totalActions;
  int totalInteractions, totalInteractionLength;
  int totalPartners, totalInteractants;
  int totalPopulationSize, totalPopulatedCells;
  int startEnergy, livingCost, worldTime;
  float mutationRate, crossProbability;
  double deathProbability, moveProbability, defectorProbability, cooperationLevel, globalRelatedness;
//  id <ListIndex> allAgents;
  id allAgents;
  id <Array> alleleFrequencies;
  id <Array> alleleTotals;
  id <Array> strategyFrequencies;
  id payoffs;
  id worldDisplay, populationDisplay;
  id cellTotalDiversity, cellDiversityDivisor, cellTotalCooperativeActions, cellTotalActions;
//  id <ListIndex> cooperationValues;
  id cooperationValues;
//  id <ListIndex> relatednessValues;
  id relatednessValues;
}

-setupMaxAgents: (int) maxPop maxLocalAgents: (int) maxLocalPop startAgents: (int) startPop strategyLength: (int) stratLen strategyNumber: (int) stratNum deathProbability: (double) deathProb moveProbability: (double) moveProb defectorProbability: (double) defectorProb mutationRate: (float) mu crossProbability: (float) crossProb agentList: aListIndex payoffMatrix: anArray worldDisplay: aDisplay populationDisplay: bDisplay startEnergy: (int) startEnergy livingCost: (int) livingCost;

-createEnd;
-(void)drop;

-populate;
-addAgent: newAgent;
-purge;
-mate;
-display;
-(int)getMaxAgents;
-(int)getMaxLocalAgents;
-(int)getWorldPopulation;
-getAllAgents;
-(int)getGlobalRelatedness;
-increaseGlobalRelatedness: (double) increase;
-resetGlobalRelatedness;
-(int)getStrategyLength;
-(double)getDeathProbability;
-(double)getMoveProbability;
-(float)getMutationRate;
-(float)getCrossProbability;
-(int)getPayoffAction1: (int) action1 action2: (int) action2;
-resetCoopLevel;
-(int)getCoopLevel;
-increaseAlleleFrequency: (int) alleleNum;
-decreaseAlleleFrequency: (int) alleleNum;
-getAlleleFrequency: (int) alleleNum;
-updateAverageAlleleFrequency: (int) alleleNum Increment: (int) alleleInc Population: (int) pop;
-(int)getAverageAlleleFrequency: (int) alleleNum;
-increaseStrategyFrequency: (int) strategyNum;
-decreaseStrategyFrequency: (int) strategyNum;
-getStrategyFrequency: (int) strategyNum;
-updateCoopLevelMyAction: (int) action1 TheirAction: (int) action2;
-(int)getStartEnergy;
-(int)getLivingCost;
-(int)getWorldTime;
-incrementWorldTime;
-storeValues;
-(int)getAverageCooperationLevel;
-(double)getAverageNumberOfPartners;
-(int)getAverageRelatedness;
-(double)getAverageInteractionLength;
-updateAverageLocalPopSize;
-(double)getAverageLocalPopSize;
-getWorldDisplay;
-resetDisplay;
-incrementTotalActionsAtX: (int) x Y: (int) y NumActions: (int) numActions;
-incrementTotalCooperativeActionsAtX: (int) x Y: (int) y NumCoopActions: (int) numCoopActions;
-incrementTotalDiversityAtX: (int) x Y: (int) y Diversity: (double) diversity;
-(double)getCooperationLevelAtX: (int) x Y: (int) y;
-(double)getDiversityLevelAtX: (int) x Y: (int) y;
-resetCellTotalActions;
-resetCellTotalDiversity;
@end
