package XCSphere;

/**
 * This class implements a hypersphere(boolean function) problem.
 * @author    James Marshall
 */
public class SphereEnvironment extends BooleanEnvironment implements Environment
{
    /**
     * @param length Specifies the problem length.
     * @param payoffMap -- not used
     * @param trackInstancesSeen Enables counting of unique problem instances seen (only suitable for small problems)
     */
    public SphereEnvironment(int length, int payoffMap, boolean trackInstancesSeen)
    {
		super(length,trackInstancesSeen);
		if (length != 11)
		{
			throw new IllegalArgumentException("SphereEnvironment must be of length 11 at present");
		}
    }


    /**
     * Implements a hypersphere function on the current state and compare to the
     * current action.
     *
     * @param action Specifies the classification.
     */
    public boolean isCorrect(int action)
    {
	int oneBits = 0;
	int stateValue;
	for(int i=0; i<conLength; i++){
	    if(currentState[i]=='1'){
		oneBits ++;
	    }
	}
	if (oneBits <= 5)
	{
		stateValue = 1;
	}
	else
	{
		stateValue = 0;
	}

	if(action == stateValue)
		return true;
	else
		return false;
    }
}
